// resolve.m -- resolve an address using gethostbyname2()

#import <sys/types.h>	// random types
#import <sys/socket.h>	// for AF_INET
#import <netinet/in.h>	// constants and types
#import <arpa/inet.h>	// for inet_ntop
#import <stdlib.h>	// for EXIT_SUCCESS
#import <netdb.h>	// for gethostbyname
#import <stdio.h>	// for fprintf

/* compile with
cc -g -Wmost -o resolve resolve.m
*/



int main (int argc, char *argv[])
{
    struct hostent *hostinfo;

    hostinfo = gethostbyname2 ("www.apple.com", AF_INET);

    if (hostinfo == NULL) {
        fprintf (stderr, "error with gethostbyname2 / apple.  error %s\n",
                 hstrerror(h_errno));

    } else {
        // pointer used to step through hostent's arrays of pointers
        char **scan;

        printf ("gethostbyname www.apple.com\n");
        printf ("    official name: %s\n", hostinfo->h_name);

        // any aliases?  If so, print them out
        if (hostinfo->h_aliases[0] != NULL) {
            scan = hostinfo->h_aliases;
            printf ("    aliases:\n");
            while (*scan != NULL) {
                printf ("        %s\n", *scan);
                scan++;
            }
        } else {
            printf ("    no aliases\n");
        }

        printf ("    h_addrtype: %d (%s)\n", 
                hostinfo->h_addrtype,
                (hostinfo->h_addrtype == AF_INET) ? "AF_INET" 
                : (hostinfo->h_addrtype == AF_INET6) ? "AF_INET6"
                : "unknown");

        // additional addresses?  If so, print them out
        if (hostinfo->h_addr_list[0] != NULL) {
            scan = hostinfo->h_addr_list;
            printf ("    addresses:\n");
            while (*scan != NULL) {
                char addrBuffer[INET_ADDRSTRLEN];
                printf ("        %s\n", 
                        inet_ntop(AF_INET, *scan,
                                  addrBuffer, sizeof(addrBuffer)));
                scan++;
            }
        } else {
            printf ("    no addresses\n");
        }
    }

    return (EXIT_SUCCESS);

} // main
