#import <mach/mach_time.h>  // for mach_absolute_time() and friends
#import <stdio.h>           // for printf()
#import <stdlib.h>          // for abort()

/* compile with
gcc -g -Wall -o machtime machtime.m
*/

int main (void)
{
    mach_timebase_info_data_t info;

    uint64_t start, end, elapsed;
    start = mach_absolute_time ();

    if (mach_timebase_info (&info) == KERN_SUCCESS) {
        printf ("%u %u\n", info.numer, info.denom);
    } else {
        printf ("mach_timebase_info failed\n");
        abort ();
    }

    end = mach_absolute_time ();
    elapsed = end - start;

    uint64_t nanos;
    nanos = elapsed * info.numer / info.denom;

    printf ("elapsed time was %lld nanoseconds\n", nanos);

    return (0);

} // main
