// mallocalign.m -- see how malloc aligns its pointers

/* compile with
cc -Wmost -g -o mallocalign mallocalign.m
*/

#import <stdio.h>   // for printf()
#import <stdlib.h>  // for malloc()

void allocprint (size_t size)
{
    void *memory;

    memory = malloc (size);
    printf ("malloc(%ld) == %p\n", size, memory);
    // intentionally don't free so we get a new malloced block of memory

} // allocprint

int main (int argc, char *argv[])
{
    allocprint (1);
    allocprint (2);
    allocprint (sizeof(double));
    allocprint (1024 * 1024);
    allocprint (1);
    allocprint (1);

    return (0);

} // main

