// asl-log-n-query.m -- do some logs and some queries

#import <asl.h>		// for ASL function
#import <stdio.h>	// for printf()
#import <syslog.h>	// for LOG_ constants

/* compile with this.  Need to set the env var otherwise asl_log won't link
export MACOSX_DEPLOYMENT_TARGET=10.4
cc -g -Wmost -o asl-log-n-query asl-log-n-query.m
*/

void dumpAslMsg (aslmsg message)
{
    // walk the keys and values in each message
    const char *key, *value;
    int i = 0;
    while (key = asl_key (message, i)) {
        value = asl_get (message, key);
        printf ("%d: %s => %s\n", i, key, value);
        i++;
    }

} // dumpAslMsg


int main (void)
{
    // do a simple log
    asl_log (NULL, NULL, LOG_NOTICE, "hello, how are %s today?", "you");

    // make a template message with our custom tags
    aslmsg template = asl_new (ASL_TYPE_MSG);
    asl_set (template, "Suit", "(4A)CGS");

    // log some messages
    asl_log (NULL, template, LOG_NOTICE, "Laurel has suited up");
    asl_log (NULL, template, LOG_NOTICE, "Alex has suited up");

    // do a query to see how many times Alex has worn his 
    // (4A)CGS suit

    aslmsg query;
    query = asl_new (ASL_TYPE_QUERY);

    asl_set_query (query, "Suit", "(4A)CGS", ASL_QUERY_OP_EQUAL);
    asl_set_query (query, ASL_KEY_MSG, "Alex", ASL_QUERY_OP_REGEX);

    // perform the search
    aslresponse results = asl_search (NULL, query);

    // walk the returned messages
    aslmsg message;
    while (message = aslresponse_next(results)) {
        dumpAslMsg (message);
        printf ("----------------------------------------\n");
    }

    aslresponse_free (results);
    asl_free (query);

    asl_free (template);
    
    return (0);

} // main

