// NoisyCount -- an object that NSLogs when it gets retained and released

#import "NoisyCount.h"

@implementation NoisyCount


- (id) retain
{
    NSLog (@"retain for %p", self);
    return (self);
} // retain



- (oneway void) release
{
    NSLog (@"release for %p", self);
} // release



- (id) autorelease
{
    NSLog (@"autorelease for %p", self);
    return (self);
} // autorelease



- (unsigned) retainCount
{
    NSLog (@"retain count for %p", self);
    return (1);
} // retainCount



// this is a method just to show that the object can react to messages
// during undo operations

- (void) doStuff: (id) sender
{
    NSLog (@"doStuff");
} // doStuff



@end // NoisyCount
