// UndoDocument - a document (that doesn't save anything) to show using undo
//                in a document settingx

#import <Cocoa/Cocoa.h>

@class NoisyCount;

@interface UndoDocument : NSDocument
{
    // These are our 'model objects'  These are the values that get
    // updated during undo and redo operations
    NSCellStateValue state1, state2, state3; // NSCellStateValue
    int dwarfValue;
    int sliderValue;
    NSString *borkValue;

    // this is another object that shows retains and releases
    NoisyCount *noisyCount;

    // undoable UI jazz - these are the items that get updated when
    // undo and redo happens
    IBOutlet NSButton *checkbox1;
    IBOutlet NSButton *checkbox2;
    IBOutlet NSButton *checkbox3;

    IBOutlet NSMatrix *dwarfMatrix;
    IBOutlet NSTextField *borkString;
    IBOutlet NSSlider *slider;

    // sample code support
    IBOutlet NSTextField *groupName;
}

// the actions triggered by the UI objects
- (IBAction) handleCheckboxOne: (id) sender;
- (IBAction) handleCheckboxTwo: (id) sender;
- (IBAction) handleCheckboxThree: (id) sender;
- (IBAction) handleChangeDwarf: (id) sender;
- (IBAction) handleBorkField: (id) sender;
- (IBAction) handleSlider: (id) sender;

// purge the undo stack
- (IBAction) clearUndo: (id) sender;

// open / close a custom undo group
- (IBAction) handleUndoGroup: (id) sender;

// forward reference to tell the text field to commit itselfx
- (void) commitTextfield;

@end
